// JavaScript for slider interaction
document.addEventListener('DOMContentLoaded', () => {
    const slides = document.querySelectorAll('.slide');
    const prevButton = document.getElementById('prev');
    const nextButton = document.getElementById('next');
    let currentIndex = 0;

    function changeSlide(index) {
        if (index < 0) {
            currentIndex = slides.length - 1; // Loop to the last slide
        } else if (index >= slides.length) {
            currentIndex = 0; // Loop to the first slide
        } else {
            currentIndex = index;
        }

        // Update the slider's transform property to show the current slide
        const offset = -100 * currentIndex;
        slides.forEach(slide => slide.style.transform = `translateX(${offset}%)`);
    }

    // Next button click event
    nextButton.addEventListener('click', () => {
        changeSlide(currentIndex + 1);
    });

    // Previous button click event
    prevButton.addEventListener('click', () => {
        changeSlide(currentIndex - 1);
    });

    // Auto slide change every 5 seconds
    setInterval(() => {
        changeSlide(currentIndex + 1);
    }, 5000);
});
